import type { NextApiRequest, NextApiResponse } from 'next';
import { prisma } from '@/lib/prisma';

export default async function handler(
    req: NextApiRequest,
    res: NextApiResponse
) {
    const { id } = req.query;

    if (req.method === 'PUT') {
        const { name, openaiApiKey, workflowId } = req.body;
        try {
            const client = await prisma.client.update({
                where: { id: String(id) },
                data: {
                    name,
                    openaiApiKey,
                    workflowId,
                },
            });
            return res.status(200).json(client);
        } catch (error) {
            return res.status(500).json({ error: 'Failed to update client' });
        }
    } else if (req.method === 'DELETE') {
        try {
            await prisma.client.delete({
                where: { id: String(id) },
            });
            return res.status(204).end();
        } catch (error) {
            return res.status(500).json({ error: 'Failed to delete client' });
        }
    } else {
        res.setHeader('Allow', ['PUT', 'DELETE']);
        res.status(405).end(`Method ${req.method} Not Allowed`);
    }
}
